//
//  table__g_v_a_r.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.08.16.
//  Copyright 2016 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>

@class FTPointArray;
@class GSIntArray;

NSArray *range(NSUInteger count);

@interface table__g_v_a_r : TTable {}

@property (nonatomic) uint16_t version;				// H
@property (nonatomic) uint16_t reserved;			// H
@property (nonatomic) uint16_t axisCount;			// H
@property (nonatomic) uint16_t sharedCoordCount;	// H
@property (nonatomic) uint16_t glyphCount;			// H
@property (nonatomic) uint16_t flags;				// H
@property (nonatomic, strong) NSMutableDictionary<NSString *, NSArray *> *variations;

- (NSArray *)decompileGlyph:(NSData *)data pointCount:(NSUInteger)pointCount sharedTuples:(NSArray *)sharedTuples axisTags:(NSArray *)axisTags;
+ (NSArray *)decompileOffsets:(NSData *)data tableFormat:(unsigned short)tableFormat glyphCount:(NSUInteger)glyphCount;

//- (NSArray *)decompileGlyph:(NSData *)data pointCount:(NSUInteger)pointCount sharedCoords:(NSArray *)sharedCoords axisTags:(NSArray *)axisTags;
//+ (NSArray *)computeMinMaxCoord:(NSDictionary*)coord;
//
//- (NSData *)compileGlyph:(NSString*)glyphName pointCount:(NSUInteger)pointCount axisTags:(NSArray *)axisTags sharedCoordIndices:(NSDictionary*)sharedCoordIndices error:(NSError **)error;
//- (NSArray *)compileSharedCoords:(NSArray *)axisTags;

- (NSData *)compileGlyph:(NSString *)glyphName pointCount:(NSUInteger)pointCount axisTags:(NSArray *)axisTags sharedCoordIndices:(NSDictionary *)sharedCoordIndices error:(NSError **)error;

+ (NSData *)compileOffsets:(NSArray *)offsets tableFormat:(short *)tableFormat;
@end
